/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.base.connectors;

import data.base.Database;
import data.base.NoBaseException;
import data.structures.base.Flux;
import data.structures.base.Source;
import data.structures.base.Tag;

import proc.text.Codecs;

import java.sql.ResultSet;

import java.util.Vector;

public class ManagementDatabase {

    public final static int TAGS_CATEGORIE = RSSFeedDatabase.TAGS_CATEGORIE;
    public final static int TAGS_PAYS = RSSFeedDatabase.TAGS_PAYS;
    public final static int TAGS_COUVERTURE = RSSFeedDatabase.TAGS_COUVERTURE;
    public final static int TAGS_INFORMATION = RSSFeedDatabase.TAGS_INFORMATION;
    public final static int TAGS_EXTERNE = RSSFeedDatabase.TAGS_EXTERNE;

    private Database theDB;

    public ManagementDatabase(Database db) throws NoBaseException {
        theDB = db;
    }

    public Tag[] getTags() throws NoBaseException {
        String query = "SELECT id, tag FROM rss_tags;";
        ResultSet tags = theDB.executeSelection(query);

        Vector<Tag> res = new Vector<Tag>();
        if (tags != null) {
            try {
                while (tags.next()) { // process results one row at a time

                    int id = tags.getInt("id");
                    String tag = Codecs.desEscapeHTML(tags.getString("tag"));
                    res.addElement(new Tag(id, tag));
                }
                tags.close();
            } catch (Exception e) {
                return new Tag[]{};
            }
        }
        Tag[] res2 = new Tag[res.size()];
        res.toArray(res2);
        return res2;
    }

    public void supprimeTag(int id) throws NoBaseException {
        String query = "DELETE FROM rss_tags WHERE id="+id+";";
        theDB.executeDeletion(query);
        assureCoherence();
    }

    public void ajouteTag(int id, String nom) throws NoBaseException {
        String query = "INSERT INTO rss_tags(id, tag) VALUES("+id+", '"+
                Codecs.escapeHTML(nom)+"');";
        theDB.executeInsertOrUpdate(query);
    }

    public void modifieTag(int ancienId, int nouvelId, String nouveauNom)
            throws NoBaseException {
        String query = "UPDATE rss_tags SET id="+nouvelId+", tag='"+
                Codecs.escapeHTML(nouveauNom)+
                "' WHERE id="+ancienId+";";
        theDB.executeInsertOrUpdate(query);
    }

    public Source[] getSources() throws NoBaseException {
        String query = "SELECT id, nom, homePage FROM rss_sources;";
        ResultSet tags = theDB.executeSelection(query);

        Vector<Source> res = new Vector<Source>();
        if (tags != null) {
            try {
                while (tags.next()) { // process results one row at a time

                    int id = tags.getInt("id");
                    String nom = Codecs.desEscapeHTML(tags.getString("nom"));
                    String homePage = Codecs.desEscapeURL(tags.getString("homePage"));
                    res.addElement(new Source(id, nom, homePage));
                }
                tags.close();
            } catch (Exception e) {
                return new Source[]{};
            }
        }
        Source[] res2 = new Source[res.size()];
        res.toArray(res2);
        return res2;
    }

    public void supprimeSource(int id) throws NoBaseException {
        String query = "DELETE FROM rss_sources WHERE id="+id+";";
        theDB.executeDeletion(query);
        assureCoherence();
    }

    public void ajouteSource(String nom, String homePage) throws NoBaseException {
        String query = "INSERT INTO rss_sources(nom, homePage) VALUES('"+
                Codecs.escapeHTML(nom)+"', '"+
                homePage+"');";
        theDB.executeInsertOrUpdate(query);
    }

    public void modifieSource(int id, String nouveauNom, String nouvellePage)
            throws NoBaseException {
        String query = "UPDATE rss_sources SET nom='"+
                Codecs.escapeHTML(nouveauNom)+"', homePage='"+
                nouvellePage+"' WHERE id="+id+";";
        theDB.executeInsertOrUpdate(query);
    }

    public Flux[] getFlux() throws NoBaseException {
        String query = "SELECT id, nom, url FROM rss_flux;";
        ResultSet tags = theDB.executeSelection(query);

        Vector<Flux> res = new Vector<Flux>();
        if (tags != null) {
            try {
                while (tags.next()) { // process results one row at a time

                    int id = tags.getInt("id");
                    String nom = Codecs.desEscapeHTML(tags.getString("nom"));
                    String url = Codecs.desEscapeURL(tags.getString("url"));
                    res.addElement(new Flux(id, nom, url));
                }
                tags.close();
            } catch (Exception e) {
                return new Flux[]{};
            }
        }
        Flux[] res2 = new Flux[res.size()];
        res.toArray(res2);
        return res2;
    }

    public void ajouteFlux(String nom, String url, Source source) throws NoBaseException {
        String query = "INSERT INTO rss_flux(nom, url, source) VALUES('"+
                Codecs.escapeHTML(nom)+"', '"+
                url+"', "+source.getId()+");";
        theDB.executeInsertOrUpdate(query);
    }

    public void modifieFlux(int id, String nouveauNom, String nouvellePage,
            Source nouvelleSource)
            throws NoBaseException {
        String query = "UPDATE rss_flux SET nom='"+
                Codecs.escapeHTML(nouveauNom)+"', url='"+
                nouvellePage+"', source="+nouvelleSource.getId()+" WHERE id="+id+";";
        theDB.executeInsertOrUpdate(query);
    }

    public void supprimeFlux(int id) throws NoBaseException {
        String query = "DELETE FROM rss_flux WHERE id="+id+";";
        theDB.executeDeletion(query);
        assureCoherence();
    }

    public Tag[] getTagsDuFlux(Flux flux) throws NoBaseException {
        String query = "SELECT t.id, t.tag FROM rss_tags t, rss_tagflux f " +
                "WHERE f.flux="+flux.getId()+" AND f.tag=t.id;";
        ResultSet tags = theDB.executeSelection(query);

        Vector<Tag> res = new Vector<Tag>();
        if (tags != null) {
            try {
                while (tags.next()) { // process results one row at a time

                    int id = tags.getInt("id");
                    String tag = Codecs.desEscapeHTML(tags.getString("tag"));
                    res.addElement(new Tag(id, tag));
                }
                tags.close();
            } catch (Exception e) {
                return new Tag[]{};
            }
        }
        Tag[] res2 = new Tag[res.size()];
        res.toArray(res2);
        return res2;
    }

    public Source getSourceDuFlux(Flux flux) throws NoBaseException {
        String query = "SELECT s.id, s.nom, s.homePage FROM rss_sources s, rss_flux f " +
                "WHERE f.id="+flux.getId()+" AND f.source=s.id;";
        ResultSet tags = theDB.executeSelection(query);

        Source res = null;
        if (tags != null) {
            try {
                while (tags.next()) { // process results one row at a time

                    int id = tags.getInt("id");
                    String nom = Codecs.desEscapeHTML(tags.getString("nom"));
                    String homePage = Codecs.desEscapeURL(tags.getString("homePage"));
                    res = new Source(id, nom, homePage);
                }
                tags.close();
            } catch (Exception e) {
                return null;
            }
        }
        return res;
    }

    public void ajouteTagAuFlux(Tag tag, Flux flux) throws NoBaseException {
        String query = "INSERT INTO rss_tagflux(flux, tag) VALUES("+flux.getId()+", "+
                tag.getId()+");";
        theDB.executeInsertOrUpdate(query);
    }

    public void supprimeTagDuFlux(Tag tag, Flux flux) throws NoBaseException {
        String query = "DELETE FROM rss_tagflux WHERE flux="+flux.getId()+" AND tag="+
                tag.getId()+";";
        theDB.executeDeletion(query);
    }

    private void assureCoherence() throws NoBaseException {
        String query = "DELETE FROM rss_flux WHERE source NOT IN (" +
                "SELECT id FROM rss_source);";
        theDB.executeDeletion(query);
        query = "DELETE FROM rss_tagflux WHERE tag NOT IN (" +
                "SELECT id FROM rss_tags);";
        theDB.executeDeletion(query);
        query = "DELETE FROM rss_tagflux WHERE flux NOT IN (" +
                "SELECT id FROM rss_flux);";
        theDB.executeDeletion(query);
    }

}
